package gov.va.med.mhv.sm.api.enumeration;

import java.util.Arrays;
import java.util.List;

public enum MessageArchivePeriodEnum {
	
	LAST_6_MONTHS(1L,"Last 6 months"),
	LAST_YEAR(2L,"Last year"),
	LAST_2_YEAR(3L,"Last 2 years"),
	ALL(4L,"All of them");
	
	private Long id;
	private String name;
	
	private MessageArchivePeriodEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static MessageArchivePeriodEnum valueOf(Long value) throws Exception{
		for(MessageArchivePeriodEnum f : MessageArchivePeriodEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new Exception("No SourceEnum found matching " + value);
	}
	
	public static List<MessageArchivePeriodEnum> toList(){
		return Arrays.asList(MessageArchivePeriodEnum.values());
	}
}
